/*****************************************************************************
*  LPC81x RC5 decoder program for MicroCore48 rev B board
*
*  1. Use SCT timer to capture and decode RC5 messages.
*  2. Use USART to print received RC5 frames to PC terminal
*****************************************************************************/
#include "LPC8xx.h"
#include "global.h"

int main (void) 
{
    LPC_SWM->PINASSIGN5 = 0x07FFFFFF;              // SCT INP_0 at P0.7

    USART0_Init(19200);
    RC5_Init();

    PrintString("\f\nLPC800 SCT-RC5 test Januari 2013\n\n");

    while (1)
    {
        if (RC5_flag)                              // wait for RC5 code
        {
            RC5_flag = 0;                          // clear flag
            PrintString("RC5 = ");                 // and print it
            PrintByte(RC5_System);
            PrintString(" ");
            PrintByte(RC5_Command);
            PrintString("\n");
        }
    }
}
